﻿'=============================================================================
' USB IO Board Controller v2.0
' Copyright www.Electronics-DIY.com © 2002-2012. All Rights Reserved. 
' THIS SOURCECODE CAN ONLY BE USED FOR PERSONAL USE
' DO NOT REPRODUCE WITHOUT PERMISSION
'=============================================================================
' Compiled with free Visual Basic Express 2008 
' http://www.microsoft.com/visualstudio/en-us/products/2008-editions/express
'=============================================================================

Imports System.IO.Ports

Public Class Form1
    Public WithEvents Port As SerialPort = New SerialPort("COM1", 57600, Parity.None, 8, StopBits.One)

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        ListCOMPorts()
    End Sub

    'List COM Ports
    Private Sub ListCOMPorts()
        For Each s As String In SerialPort.GetPortNames()
            cboCOMPorts.Items.Add(s)
        Next
        cboCOMPorts.Sorted = True
    End Sub

    'Connect to COM Port
    Private Sub cbo_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cboCOMPorts.SelectedIndexChanged
        Try
            Port.PortName = cboCOMPorts.SelectedItem

            If Not Port.IsOpen Then
                StatusBar.Text = "Connected to " & Port.PortName
                Port.Open()
            End If
        Catch ex As Exception
            MsgBox(ex.Message)
        End Try
    End Sub

    'Send Command to USB IO Board
    Private Sub btnSendCommand_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnSendCommand.Click
        If Port.IsOpen Then
            'Port.Write("C,0,0,0,0" & vbCr) 'Example: Configure all ports as outputs
            Port.Write(cboCommandInput.Text & vbCr)
            System.Threading.Thread.Sleep(100) 'ms
            ReceiveData()
        Else
            StatusBar.Text = "Select COM port"
        End If
    End Sub

    'Receive Data from USB IO Board
    Private Sub ReceiveData()
        Dim output As String
        Dim Buffer(Port.BytesToRead - 1) As Byte

        Port.Read(Buffer, 0, Port.BytesToRead)

        For i As Integer = 0 To Buffer.Length - 1
            output &= Chr(Buffer(i))
        Next
        txtOutput.Text = output & txtOutput.Text
    End Sub
End Class
